// content.js
// 这个文件会被注入到匹配的网页中

console.log('QDD Extension content script loaded');

// 监听来自插件的消息
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    console.log('Message received in content script:', request);
    
    // 根据消息类型处理不同的操作
    switch (request.type) {
        case 'GET_PAGE_INFO':
            // 获取页面信息的逻辑
            const pageInfo = {
                url: window.location.href,
                title: document.title
            };
            sendResponse(pageInfo);
            break;
            
        // 可以添加其他消息类型的处理
        default:
            console.log('Unknown message type:', request.type);
            break;
    }
    
    // 返回 true 表示会异步发送响应
    return true;
});

// 初始化内容脚本
const init = () => {
    console.log('QDD Extension content script initialized');
    // 这里可以添加页面加载完成后需要执行的逻辑
};

// 当页面加载完成时执行初始化
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
} else {
    init();
} 