import{AuthService}from"../../../services/index.js";export class RegisterManager{static instance=null;registerContainer=null;static getInstance(){return RegisterManager.instance||(RegisterManager.instance=new RegisterManager),RegisterManager.instance}constructor(){console.log("RegisterManager constructor called"),this.init()}async init(){console.log("Initializing register page");try{await this.loadRegisterTemplate(),this.initEventListeners()}catch(e){console.error("Register initialization failed:",e)}}async loadRegisterTemplate(){console.log("Loading register template");try{const e=chrome.runtime.getURL("popup/components/register/register.html"),t=await fetch(e),r=await t.text();document.body.insertAdjacentHTML("beforeend",r);const s=document.createElement("link");s.rel="stylesheet",s.href=chrome.runtime.getURL("popup/components/register/register.css"),document.head.appendChild(s),this.registerContainer=document.getElementById("registerContainer")}catch(e){console.error("Failed to load register template:",e)}}initEventListeners(){if(!this.registerContainer)return;const e=document.getElementById("registerButton");e&&e.addEventListener("click",(()=>{console.log("registerBtn button clicked"),this.showLoginModal()}));const t=this.registerContainer.querySelector("#registerBackButton");t&&t.addEventListener("click",(()=>{this.hideRegisterPage()}));const r=this.registerContainer.querySelector("#registerClearButton");r&&r.addEventListener("click",(()=>{this.clearForm()}));this.registerContainer.querySelectorAll(".toggle-password").forEach((e=>{e.addEventListener("click",(e=>{this.togglePasswordVisibility(e)}))}));const s=this.registerContainer.querySelector("#countryCode");s&&(s.addEventListener("change",(()=>{this.updatePhoneFormatHint()})),this.updatePhoneFormatHint());const i=this.registerContainer.querySelector("#registerForm");i&&i.addEventListener("submit",(e=>{e.preventDefault(),this.handleRegister()}));const o=this.registerContainer.querySelector("#termsLink"),n=this.registerContainer.querySelector("#privacyLink");o&&o.addEventListener("click",(e=>{e.preventDefault(),chrome.tabs.create({url:"https://www.qoo10bi.com/terms"})})),n&&n.addEventListener("click",(e=>{e.preventDefault(),chrome.tabs.create({url:"https://www.qoo10bi.com/privacy"})}))}updatePhoneFormatHint(){const e=document.getElementById("countryCode").value,t=this.registerContainer.querySelector(".phone-format-hint");if(t)switch(e){case"CN":t.textContent="格式示例：13812345678";break;case"JP":t.textContent="格式示例：07012345678 或 070-1234-5678";break;case"KR":t.textContent="格式示例：01012345678 或 010-1234-5678";break;default:t.textContent="请输入有效的手机号码"}}showRegisterPage(){this.registerContainer&&this.registerContainer.classList.add("active")}hideRegisterPage(){this.registerContainer&&this.registerContainer.classList.remove("active")}togglePasswordVisibility(e){const t=e.currentTarget,r=t.getAttribute("data-target"),s=document.getElementById(r),i=t.querySelector("img");s&&i&&("password"===s.type?(s.type="text",i.src="../assets/mainimages/eye-open.png"):(s.type="password",i.src="../assets/mainimages/eye-close.png"))}clearForm(){const e=this.registerContainer.querySelector("#registerForm");if(e){e.reset();e.querySelectorAll(".form-group.error").forEach((e=>{e.classList.remove("error")}));const t=e.querySelector("#registerErrorMessage");t&&t.classList.remove("visible"),this.updatePhoneFormatHint()}}validateForm(){let e=!0;const t=document.getElementById("registerName"),r=document.getElementById("countryCode"),s=document.getElementById("registerPhone"),i=document.getElementById("registerPassword"),o=document.getElementById("confirmPassword"),n=document.getElementById("agreeTerms");return t.value.trim()?t.value.trim().length<3||t.value.trim().length>50?(this.showFieldError(t,"姓名长度应为3-50个字符"),e=!1):this.clearFieldError(t):(this.showFieldError(t,"请输入姓名"),e=!1),s.value.trim()?this.isValidPhone(s.value,r.value)?this.clearFieldError(s):(this.showFieldError(s,"请输入有效的手机号码"),e=!1):(this.showFieldError(s,"请输入手机号"),e=!1),i.value.trim()?i.value.length<6||i.value.length>20?(this.showFieldError(i,"密码长度应为6-20个字符"),e=!1):this.clearFieldError(i):(this.showFieldError(i,"请输入密码"),e=!1),o.value.trim()?o.value!==i.value?(this.showFieldError(o,"两次输入的密码不一致"),e=!1):this.clearFieldError(o):(this.showFieldError(o,"请确认密码"),e=!1),n.checked||(this.showError("请阅读并同意用户协议和隐私政策"),e=!1),e}isValidPhone(e,t){const r=e.replace(/\D/g,"");switch(t){case"CN":return/^1\d{10}$/.test(r);case"JP":return/^(070|080|090)\d{8}$/.test(r);case"KR":return/^(010|011|016|017|018|019)\d{7,8}$/.test(r);default:return!1}}showFieldError(e,t){const r=e.closest(".form-group");r.classList.add("error"),r.querySelector(".error-tip").textContent=t}clearFieldError(e){e.closest(".form-group").classList.remove("error")}showError(e){const t=document.getElementById("registerErrorMessage");t&&(t.textContent=e,t.classList.add("visible"))}hideError(){const e=document.getElementById("registerErrorMessage");e&&e.classList.remove("visible")}async handleRegister(){if(!this.validateForm())return;const e=document.getElementById("registerName").value,t=document.getElementById("countryCode").value,r=document.getElementById("registerPhone").value.replace(/\D/g,""),s=document.getElementById("registerPassword").value,i=this.registerContainer.querySelector(".register-submit-btn");i.disabled=!0,i.textContent="注册中...",this.hideError();try{const i={phone:r,password:s,countryCode:t};e.trim()&&(i.name=e.trim()),console.log("注册请求:",i);await AuthService.register(i);this.showSuccessMessage("注册成功！请返回登录"),setTimeout((()=>{this.hideRegisterPage()}),3e3)}catch(e){this.showError(e.message||"注册失败，请稍后重试"),console.error("注册失败:",e)}finally{i.disabled=!1,i.textContent="注 册"}}showSuccessMessage(e){const t=document.getElementById("registerErrorMessage");t&&(t.textContent=e,t.style.color="#52c41a",t.style.backgroundColor="#f6ffed",t.classList.add("visible"))}}document.addEventListener("DOMContentLoaded",(()=>{console.log("DOMContentLoaded fired"),RegisterManager.getInstance()}));