// 处理头像下拉菜单的交互逻辑
function initAvatarDropdown() {
    const avatarDropdown = document.getElementById("avatarDropdown");
    if (!avatarDropdown) return;

    // 点击头像切换下拉菜单
    avatarDropdown.addEventListener("click", function(e) {
        e.stopPropagation();
        this.classList.toggle("active");
    });

    // 点击页面其他区域关闭下拉
    document.addEventListener("click", () => {
        avatarDropdown.classList.remove("active");
    });

    // 阻止下拉菜单区域点击冒泡
    const dropdownContent = document.querySelector(".dropdown-content");
    if (dropdownContent) {
        dropdownContent.addEventListener("click", (e) => {
            e.stopPropagation();
        });
    }
}

// 直接执行初始化
document.addEventListener('DOMContentLoaded', initAvatarDropdown); 