import { initShopDetail } from "./components/shopDetail/shopDetail.js";
import { initTimeSaleSetting } from "./components/timeSaleSetting/timeSaleSetting.js";
import { PageStateManager } from "./utils/PageStateManager.js";
import { initMemberRecharge } from "./components/memberRecharge/memberRecharge.js";
import { LoginManager } from "./components/login/login.js";
import { RegisterManager } from "./components/register/register.js";
import { AuthService } from "../../../services/index.js";
import config from "../config/config.js";

document.addEventListener("DOMContentLoaded", async function () {
  console.log("DOM加载完成"); // 检查DOMContentLoaded是否触发

  const pageManager = new PageStateManager();
  const loginManager = LoginManager.getInstance();
  const registerManager = RegisterManager.getInstance();
  let memberRechargeComponent = null; // 声明变量

  // 根据保存的状态初始化页面
  const currentPage = pageManager.getCurrentPage();
  // 检查当前页面
  if (currentPage !== "home") {
    // 根据页面名称显示对应组件
    switch (currentPage) {
      case "timeSaleSetting":
        const timeSaleSetting = await initTimeSaleSetting();
        timeSaleSetting.show();
        break;
      case "shopDetail":
        const shopDetail = await initShopDetail(pageManager);
        shopDetail.show();
        break;
      case "memberRecharge":
        memberRechargeComponent = await initMemberRecharge();
        memberRechargeComponent.show();
        break;
      // ... 其他页面的处理
    }
  }

  // ERP系统入口按钮点击事件
  document.getElementById("goERP").addEventListener("click", function () {
    // 打开ERP系统的入口链接
    chrome.tabs.create({ url: "http://qoo10bi.com/keyword-trend" });
  });

  // 各个页面的点击事件
  document
    .getElementById("timeSaleSettingButton")
    .addEventListener("click", async function () {
      if (!AuthService.isLoggedIn()) {
        loginManager.showLoginModal();
        return;
      }
      const timeSaleSetting = await initTimeSaleSetting();
      timeSaleSetting.show();
      pageManager.saveCurrentPage("timeSaleSetting");
    });

  // 添加点击事件监听
  document
    .getElementById("shopDetailButton")
    .addEventListener("click", async function () {
      if (!AuthService.isLoggedIn()) {
        loginManager.showLoginModal();
        return;
      }
      const shopDetail = await initShopDetail(pageManager);
      shopDetail.show();
      pageManager.saveCurrentPage("shopDetail");
    });

  // 会员充值按钮点击事件
  document
    .getElementById("memberRechargeButton")
    .addEventListener("click", async function () {
      if (!AuthService.isLoggedIn()) {
        loginManager.showLoginModal();
        return;
      }
      try {
        if (!memberRechargeComponent) {
          memberRechargeComponent = await initMemberRecharge();
        }
        if (memberRechargeComponent) {
          memberRechargeComponent.show();
          pageManager.saveCurrentPage("memberRecharge");
        }
      } catch (error) {
        console.error("Error showing member recharge:", error);
      }
    });

  // 返回按钮点击时清除状态
  document
    .querySelector(".back-button")
    ?.addEventListener("click", function () {
      pageManager.saveCurrentPage("home");
    });

  
  // 注册按钮点击事件
  document.getElementById('registerButton').addEventListener('click', function() {
    // 使用登录管理器，但传入注册模式参数
    console.log('注册按钮被点击', registerManager.showRegisterPage);
    registerManager.showRegisterPage();
  });

  // 初始化配置
  await config.init();
  
  // 检查登录状态
  await loginManager.checkLoginStatus();

  // 绑定登录按钮点击事件
  const loginBtn = document.querySelector(".login-btn");
  if (loginBtn) {
    console.log("找到登录按钮，绑定点击事件");
    loginBtn.addEventListener("click", () => {
      console.log("登录按钮被点击");
      loginManager.showLoginModal();
    });
  } else {
    console.error("未找到登录按钮");
  }
  
  // 绑定退出按钮点击事件
  const logoutBtn = document.getElementById("logoutButton");
  if (logoutBtn) {
    logoutBtn.addEventListener("click", async () => {
      try {
        await AuthService.logout();
        window.location.reload(); // 退出后刷新页面
      } catch (error) {
        console.error("退出失败:", error);
        alert("退出失败: " + error.message);
      }
    });
  }
});
