export class LocalTempDataStorage {
    static instance = null;
    
    constructor() {
        if (LocalTempDataStorage.instance) {
            return LocalTempDataStorage.instance;
        }
        LocalTempDataStorage.instance = this;
        this.initializeStore();
    }

    // 初始化存储结构
    initializeStore() {
        const store = localStorage.getItem('QDD_STORE');
        if (!store) {
            const initialStore = {
                timeSaleSetting: {
                    storeInfo: null,
                    products: [],
                    settings: {}
                },
                shopBinding: {
                    shops: [],
                    settings: {}
                },
                keywordSetting: {
                    keywords: [],
                    rules: {}
                }
            };
            localStorage.setItem('QDD_STORE', JSON.stringify(initialStore));
        }
    }

    // 获取指定模块的数据
    getModuleData(module, key = null) {
        const store = JSON.parse(localStorage.getItem('QDD_STORE')) || {};
        if (key) {
            return store[module]?.[key];
        }
        return store[module];
    }

    // 更新指定模块的数据
    setModuleData(module, key, data) {
        const store = JSON.parse(localStorage.getItem('QDD_STORE')) || {};
        if (!store[module]) {
            store[module] = {};
        }
        store[module][key] = data;
        localStorage.setItem('QDD_STORE', JSON.stringify(store));
    }

    // 获取店铺ID
    getShopId() {
        const storeInfo = this.getModuleData("timeSaleSetting", "storeInfo");
        return storeInfo?.userId;
    }
} 