import Request from "../utils/request.js";
import config from "../config/config.js";
import { showMessage } from "../utils/index.js";

/**
 * 店铺管理相关服务
 */
class ShopService {
  /**
   * 获取店铺列表
   * @returns {Promise<Object>} 店铺列表数据
   */
  static async getShopList(params) {
    try {
      const response = await Request.get(`/shop/list`);

      if (response.success) {
        return response.data;
      } else {
        showMessage(response.message || "获取店铺列表失败", "error");
        throw new Error(response.message || "获取店铺列表失败");
      }
    } catch (error) {
      showMessage(error || "获取店铺列表失败", "error");
      console.error("获取店铺列表失败:", error);
      throw error;
    }
  }

  /**
   * 删除店铺绑定
   * @param {Object} params - 请求参数
   * @param {string} params.platformUserId - 平台用户ID
   * @param {string} params.shopUrl - 店铺URL
   * @returns {Promise<Object>} 删除结果
   */
  static async deleteShop(params) {
    try {
      const response = await Request.delete("/shop/unbind", params);

      if (response.success) {
        return response.data;
      } else {
        showMessage(response.message || "删除店铺失败", "error");
        throw new Error(response.message || "删除店铺失败");
      }
    } catch (error) {
      showMessage(error || "删除店铺失败", "error");
      console.error("删除店铺失败:", error);
      throw error;
    }
  }

  /**
   * 绑定店铺
   * @param {Object} params - 请求参数
   * @param {string} params.platformUserId - 平台用户ID
   * @param {string} params.shopUrl - 店铺URL
   * @returns {Promise<Object>} 绑定结果
   */
  static async bindShop(params) {
    try {
      const response = await Request.post("/shop/bind", params);

      if (response.success) {
        return response.data;
      } else {
        showMessage(response.message || "店铺绑定失败", "error");
        throw new Error(response.message || "店铺绑定失败");
      }
    } catch (error) {
      showMessage(error || "绑定店铺失败", "error");
      console.error("绑定店铺失败:", error);
      throw error;
    }
  }
}

export default ShopService;
